/* ============ */
/* CalcHarm.c	*/
/* ============ */
#include <miscdefs.h>
#include <mconf.h>
/* ==================================================================== */
/* CalcHarm - Returns Harmonic corresponding to Power R and Term N	*/
/* ==================================================================== */
double
CalcHarm(int R, UINT N)
{
    UINT    k;
    double  RetVal = 0;

    /* ------------------------------------- */
    /* Calculate and Add Fractions of Series */
    /* ------------------------------------- */
    for (k = N; k >= 2; --k)
    {
	double	NewDenom = (R == 1) ? k : powi(k, R);

	RetVal += 1.0/NewDenom;
    }

    return (1.0 + RetVal);
}
# if defined(TEST_HARM)
#include <miscdefs.h>
void
main()
{
    while (main)
    {
	UINT	N;
	int	R;
	double	Value;

	GetInt("Enter Power of Harmonic Series [>=1]: ", &R);
	GetUint("Enter Number of Terms in Series: ", &N);
	Value = CalcHarm(R, N);
	printf("Harmonic = %.15e\n", Value);
    }
}
# endif
